//
//  IFViewController.m
//  PDFReader
//
//  Created by Dong Li on 12-4-25.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import "IFViewController.h"
#import "IFBarButton.h"

@interface IFViewController ()

@end

@implementation IFViewController

static UIImage *__rotationLockedIcon = nil;
static UIImage *__rotationUnlockedIcon = nil;
static UIImage *__rotationIcon = nil;

+ (void)initialize {
    __rotationLockedIcon = [UIImage imageNamed:@"bar/unrotatable.png"];
    __rotationUnlockedIcon = [UIImage imageNamed:@"bar/rotatable.png"];
    __rotationIcon = UISettingsOrientationIsLocked() ? __rotationLockedIcon : __rotationUnlockedIcon;
}

- (id)init {
    if (self = [super init]) {
        [self setAutomaticallyAdjustsScrollViewInsets:NO];
        [self setEdgesForExtendedLayout:UIRectEdgeNone];
        
        _statusBarStyle = UIStatusBarStyleDefault;
        _rotationItem = [[UIBarButtonItem alloc] initWithImage:__rotationIcon style:UIBarButtonItemStylePlain target:self action:@selector(onInvertRotationLock)];
    }
    return self;
}

- (void)setTitle:(NSString *)newTitle {
    [super setTitle:(([newTitle length] > 0) ? newTitle : nil)];
}

- (void)viewDidUnload {
    [super viewDidUnload];
    [self releaseSubviews];
    _layoutInterfaceOrientation = 0;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    
    if (!_flags.visible) {
        [self releaseSubviews];
        [self setView:nil];
        _layoutInterfaceOrientation = 0;
    }
}

- (void)releaseSubviews {
    // Inherit this method to release UI
}

- (void)dealloc {
    [self releaseSubviews];
}

- (void)viewWillAppear:(BOOL)animated {
    _flags.visible = YES;
    
    [theApplication setStatusBarStyle:_statusBarStyle animated:animated];
    [_rotationItem setImage:__rotationIcon];
    
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    
    [self layoutWithContentSize:self.viewIfLoaded.bounds.size];
}

- (void)viewDidDisappear:(BOOL)animated {
    _flags.visible = NO;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation {
    return UISettingsShouldRotateToInterfaceOrientation(toInterfaceOrientation);
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UISettingsSupportedInterfaceOrientation();
}

- (BOOL)shouldAutorotate {
    return !UISettingsOrientationIsLocked();
}

- (BOOL)prefersStatusBarHidden {
    return _flags.fullScreen;
}

- (UIStatusBarStyle)preferredStatusBarStyle {
    return _statusBarStyle;
}

- (UIStatusBarAnimation)preferredStatusBarUpdateAnimation {
    return UIStatusBarAnimationSlide;
}

- (void)viewWillTransitionToSize:(CGSize)size withTransitionCoordinator:(id<UIViewControllerTransitionCoordinator>)coordinator {
    [super viewWillTransitionToSize:size withTransitionCoordinator:coordinator];
    
    __weak typeof(self) weakSelf = self;
    
    [coordinator animateAlongsideTransitionInView:self.view animation:^(id<UIViewControllerTransitionCoordinatorContext> context) {
        __strong typeof(weakSelf) strongSelf = weakSelf;
        
        [strongSelf layoutWithContentSize:size];
    } completion:^(id<UIViewControllerTransitionCoordinatorContext> context) {
    }];
}

#pragma mark - Properties

- (BOOL)isVisible {
    return _flags.visible;
}

- (BOOL)isFullScreen {
    return _flags.fullScreen;
}

- (void)setFullScreen:(BOOL)flag {
    _flags.fullScreen = flag;
    
    UINavigationController *navigationController = [self navigationController];
    
    [theApplication setStatusBarHidden:_flags.fullScreen withAnimation:UIStatusBarAnimationSlide];
    [navigationController setNavigationBarHidden:_flags.fullScreen animated:YES];
    [navigationController setToolbarHidden:_flags.fullScreen animated:YES];
    
    NSLog(@"view: %@", self.view);
}

#pragma mark - Action

- (void)onInvertRotationLock {
    const BOOL rotationLocked = UISettingsOrientationInvertLocked();
    
    __rotationIcon = (rotationLocked ? __rotationLockedIcon : __rotationUnlockedIcon);
    [_rotationItem setImage:__rotationIcon];
    
    if (!rotationLocked) {
        UIDevice * const currentDevice = [UIDevice currentDevice];
        const UIDeviceOrientation deviceOrientation = [currentDevice orientation];
        const UIInterfaceOrientation interfaceOrientation = [theApplication statusBarOrientation];
        
        if ((UIInterfaceOrientation)deviceOrientation != interfaceOrientation && UIDeviceOrientationIsValidInterfaceOrientation(deviceOrientation)) {
            [UIViewController attemptRotationToDeviceOrientation];
        }
    }
}

#pragma mark - External

- (void)reverseFullScreen {
    [self setFullScreen:!_flags.fullScreen];
}

- (void)layoutWithContentSize:(const CGSize)contentSize {
    // Just for inheritance
}

@end
